/*****************************************************************************
*  LPC81x SCT PWM for LPC812 LPCXpresso board
*
*  1. Use SCT timer to generate a PWM output signal @ CTOUT_0
*  2. Every time P0_0 goes high to low increase the duty cycle.
*  3. Every time P0_0 goes high to low decrease the duty cycle.
*****************************************************************************/

#include "board.h"

#define match_value0 (19)
#define match_value1 (5)

void sct_fsm_init (void);

void sct_fsm_init (void)
{

	Chip_SCT_Init(LPC_SCT);														/* enable the SCT clock     */

	Chip_SCT_Config(LPC_SCT, SCT_CONFIG_16BIT_COUNTER	| SCT_CONFIG_AUTOLIMIT_L );						/* SPLIT */

	Chip_SCT_SetControl(LPC_SCT, SCT_CTRL_PRE_L(SystemCoreClock/1200000-1));	/* set prescaler, SCT clock = 1 MHz, clear counter   */



	Chip_SCT_SetMatchCount(LPC_SCT, SCT_MATCH_0, match_value0);					/* match_0_ */
	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_0, match_value0);

	Chip_SCT_SetMatchCount(LPC_SCT, SCT_MATCH_1, match_value1);					/* match_1 */
	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_1, match_value1);

	/* OUTPUT registers */

	Chip_SCT_SetOutput(LPC_SCT, SCT_OUTPUT_0, SCT_EVT_0 );  			 		/* Output_pin_0 */
	Chip_SCT_ClearOutput(LPC_SCT, SCT_OUTPUT_0, SCT_EVT_1);


	/* EVENT registers */

	Chip_SCT_EventState(LPC_SCT, SCT_EVENT_0, ENABLE_STATE0);					/* U: --> state state_1 */
	Chip_SCT_EventControl(LPC_SCT, SCT_EVENT_0, (CHIP_SCT_EVENTCTRL_T)  ( SCT_EVECTRL_MATCH0	|
                                                                        SCT_COMBMODE_MATCH	|
                                                                        SCT_STATELD_1		    |
                                                                        SCT_STATEEV_0		    ));

	Chip_SCT_EventState(LPC_SCT, SCT_EVENT_1, ENABLE_STATE0);					/* U: --> state state_1 */
	Chip_SCT_EventControl(LPC_SCT, SCT_EVENT_1, (CHIP_SCT_EVENTCTRL_T)  ( SCT_EVECTRL_MATCH1	|
                                                                        SCT_COMBMODE_MATCH	|
                                                                        SCT_STATELD_1		    |
                                                                        SCT_STATEEV_0		    ));



	Chip_SCT_ClearControl(LPC_SCT , SCT_CTRL_HALT_L);

}

void SysTick_Handler(void)
{

	if (Chip_GPIO_GetPinState(LPC_GPIO_PORT, 0,0)  & 0x01) 			/* PIO0 high or low?       */
	{
		if (LPC_SCT->MATCHREL[1].L < 19)
			LPC_SCT->MATCHREL[1].L ++;          					/* increase PWM duty cycle */
	}
	else
	{
		if (LPC_SCT->MATCHREL[1].L > 0)
			LPC_SCT->MATCHREL[1].L --;          					/* decrease PWM duty cycle */
	}
}
int main (void)
{
	/* Generic Initialization */
	SystemCoreClockUpdate();
	Board_Init();


	Chip_SWM_Init();
  
  
  Chip_SWM_DisableFixedPin(SWM_FIXED_ACMP_I1);                    //disable Pinmux for P0_0 (ACMP_I1)

	Chip_SWM_MovablePinAssign(SWM_CTOUT_0_O, 7);


    sct_fsm_init();                       		/* Initialize SCT                           */

    SysTick_Config(SystemCoreClock/24);	  		/* maximum Systick for 1 second tick value  */
    NVIC_EnableIRQ(SysTick_IRQn);         		/* enable the Systick interrupt             */

    while (1)
    {
    	__WFI();								/* loop forever                             */
    }
}
